/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.screen;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongArray;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import ru.den4k.jxera2.screen.KeySender;

public class CaptureHelper
implements Runnable {
    private static final String fileFormat = "jpg";
    private static final long TIME_FOR_SWITCH_LITE_MODE_MS = 3000L;
    public static final int CLICK_PART = 1;
    public static final int CLICK_ONE = 2;
    public static final int CLICK_DOUBLE = 3;
    public static final int CLICK_RIGHT = 4;
    private boolean mouseIsPressed = false;
    private final Robot[] robotsArr;
    private final Rectangle[] screenSizes;
    private byte[][] buffer = null;
    private final AtomicLongArray bufferReadTimeArr;
    private final int monitorCount;
    private final AtomicBoolean workEnable;

    public CaptureHelper() throws AWTException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        this.monitorCount = screens.length;
        this.bufferReadTimeArr = new AtomicLongArray(this.monitorCount);
        this.robotsArr = new Robot[this.monitorCount];
        this.screenSizes = new Rectangle[this.monitorCount];
        for (int i = 0; i < this.monitorCount; ++i) {
            this.robotsArr[i] = new Robot(screens[i]);
            this.screenSizes[i] = screens[i].getDefaultConfiguration().getBounds();
        }
        this.workEnable = new AtomicBoolean(true);
        new Thread(this).start();
    }

    private void mouseLeftClick(int monitor) {
        this.robotsArr[monitor].mousePress(1024);
        this.robotsArr[monitor].mouseRelease(1024);
    }

    private void mouseRightClick(int monitor) {
        this.robotsArr[monitor].mousePress(4096);
        this.robotsArr[monitor].mouseRelease(4096);
    }

    public void sendClick(float x, float y, int clickType, int screenIndex) {
        int monPos = screenIndex % this.screenSizes.length;
        int posX = (int)((float)this.screenSizes[monPos].x + (float)this.screenSizes[monPos].width * x);
        int posY = (int)((float)this.screenSizes[monPos].y + (float)this.screenSizes[monPos].height * y);
        this.robotsArr[monPos].mouseMove(posX, posY);
        switch (clickType) {
            case 1: {
                if (this.mouseIsPressed) {
                    this.robotsArr[screenIndex].mouseRelease(1024);
                } else {
                    this.robotsArr[screenIndex].mousePress(1024);
                }
                this.mouseIsPressed = !this.mouseIsPressed;
                break;
            }
            case 4: {
                this.mouseRightClick(screenIndex);
                break;
            }
            case 2: {
                this.mouseLeftClick(screenIndex);
                break;
            }
            case 3: {
                this.mouseLeftClick(screenIndex);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.mouseLeftClick(screenIndex);
            }
        }
    }

    private byte[][] captureScreen() throws Exception {
        return this.captureScreen(0, 0);
    }

    private byte[][] captureScreen(int width, int height) throws Exception {
        byte[][] data = new byte[this.robotsArr.length][];
        for (int i = 0; i < data.length; ++i) {
            boolean skipCapture;
            boolean bl = skipCapture = System.currentTimeMillis() - this.bufferReadTimeArr.get(i) > 3000L && this.buffer != null && this.buffer[i] != null;
            if (skipCapture) {
                data[i] = this.buffer[i];
                continue;
            }
            Rectangle rect = this.screenSizes[i];
            BufferedImage img = this.robotsArr[i].createScreenCapture(rect);
            if (width > 0 && height > 0) {
                img = Scalr.resize(img, Scalr.Method.SPEED, Scalr.Mode.AUTOMATIC, width, height, new BufferedImageOp[0]);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, fileFormat, stream);
            data[i] = stream.toByteArray();
        }
        return data;
    }

    private synchronized byte[] getSet(byte[][] source, int numMonitor) {
        if (source != null) {
            this.buffer = source;
            return null;
        }
        if (this.buffer == null) {
            return null;
        }
        return this.buffer[numMonitor];
    }

    public byte[] getBuffer(int numMonitor) {
        this.bufferReadTimeArr.set(numMonitor, System.currentTimeMillis());
        if (this.buffer == null) {
            try {
                this.getSet(this.captureScreen(), -1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getSet(null, numMonitor);
    }

    public void stop() {
        this.workEnable.set(false);
    }

    private boolean enableSkipUpdateScreenBuffer() {
        boolean res = true;
        for (int i = 0; res && i < this.bufferReadTimeArr.length(); ++i) {
            res = res && System.currentTimeMillis() - this.bufferReadTimeArr.get(i) > 3000L;
        }
        return res;
    }

    @Override
    public void run() {
        while (this.workEnable.get()) {
            if (this.enableSkipUpdateScreenBuffer()) {
                this.buffer = null;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.getSet(this.captureScreen(), -1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getMonitorCount() {
        return this.monitorCount;
    }

    public void sendText(String text, int numMonitor) {
        try {
            KeySender.pasteText(this.robotsArr[numMonitor], text);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }
}

