/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.screen;

import java.awt.AWTException;
import ru.den4k.jxera2.plugin.IJxeraPlugin;
import ru.den4k.jxera2.screen.CaptureHelper;
import ru.den4k.jxera2.server.JxeraServer;

public class ScreenPlugin
implements JxeraServer.IScreenGet,
IJxeraPlugin {
    public static final String PLUGIN_NAME = "Monitor";
    public static final String MONITORS_WORD = "monitors-count";
    public static final String DOUBLE_CLICK_WORD = "dc";
    public static final String ONE_CLICK_WORD = "oc";
    public static final String PART_CLICK_WORD = "pc";
    public static final String RIGHT_CLICK_WORD = "rc";
    public static final String CHANGE_MONITOR_WORD = "cm";
    public static final String SEND_TEXT_WORD = "st";
    public static final String NEXT_LINE_SYNONYM = "<<br>>";
    private final CaptureHelper captureHelper;
    private byte[] uploadedImg = null;
    private int currentScreenIndex = 0;

    public ScreenPlugin() {
        try {
            this.captureHelper = new CaptureHelper();
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onStop() {
        this.captureHelper.stop();
    }

    @Override
    public int getMonitorCount() {
        return this.captureHelper.getMonitorCount();
    }

    @Override
    public byte[] getScreenImage(int numMonitor) {
        return this.captureHelper.getBuffer(numMonitor);
    }

    @Override
    public void onSendClick(float x, float y, int clickType, int screenIndex) {
        this.captureHelper.sendClick(x, y, clickType, screenIndex);
    }

    public void onSendText(String text) {
        this.onSendText(text, this.currentScreenIndex);
    }

    @Override
    public void onSendText(String text, int numMonitor) {
        this.captureHelper.sendText(text, numMonitor);
    }

    @Override
    public String name() {
        return PLUGIN_NAME;
    }

    @Override
    public String description() {
        return "\u0423\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u0435 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u041f\u041a";
    }

    @Override
    public String ui(Object ... params) {
        return "";
    }

    @Override
    public void onData(IJxeraPlugin.IJxeraServerTask task, String input) {
        byte[] img;
        String[] parts = input.split(";");
        if (parts.length >= 2 && MONITORS_WORD.equals(parts[1])) {
            task.writeInt(this.getMonitorCount());
            return;
        }
        if (parts.length >= 2 && CHANGE_MONITOR_WORD.equals(parts[1])) {
            this.currentScreenIndex = (this.currentScreenIndex + 1) % this.getMonitorCount();
        }
        if ((img = this.getScreenImage(this.currentScreenIndex)) == this.uploadedImg) {
            task.writeInt(0);
        } else {
            task.writeData(img);
            this.uploadedImg = img;
        }
        if (parts.length < 2) {
            return;
        }
        if (parts.length >= 4 && this.isClickCommand(parts[1])) {
            try {
                this.onSendClick(Float.parseFloat(parts[2]), Float.parseFloat(parts[3]), this.getClickType(parts[1]), this.currentScreenIndex);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (parts.length > 2 && SEND_TEXT_WORD.equals(parts[1])) {
            StringBuilder strSend = new StringBuilder();
            for (int j = 2; j < parts.length; ++j) {
                if (strSend.length() > 0) {
                    strSend.append(";");
                }
                strSend.append(parts[j]);
            }
            this.onSendText(strSend.toString().replace(NEXT_LINE_SYNONYM, "\n"), this.currentScreenIndex);
        }
    }

    private int getClickType(String com) {
        if (DOUBLE_CLICK_WORD.equals(com)) {
            return 3;
        }
        if (PART_CLICK_WORD.equals(com)) {
            return 1;
        }
        if (RIGHT_CLICK_WORD.equals(com)) {
            return 4;
        }
        return 2;
    }

    private boolean isClickCommand(String str) {
        return ONE_CLICK_WORD.equals(str) || DOUBLE_CLICK_WORD.equals(str) || RIGHT_CLICK_WORD.equals(str) || PART_CLICK_WORD.equals(str);
    }
}

