/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.den4k.jxera2.plugin.IJxeraPlugin;
import ru.den4k.jxera2.server.ServerTask;
import ru.den4k.jxera2.utils.EncodeHelper;

public class JxeraServer
implements Runnable {
    public static final int DEFAULT_PORT = 4445;
    private final int currentPort;
    public final List<ServerTask> threadList = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean isExit = new AtomicBoolean(false);
    public Map<String, IJxeraPlugin> plugins;

    public static void sendCloseCommand(int port) {
        try (Socket socket = new Socket("127.0.0.1", port);){
            OutputStream output = socket.getOutputStream();
            output.write((EncodeHelper.getInstance().encryptAuthData() + "\n").getBytes());
            output.write("stop".getBytes());
        }
        catch (UnknownHostException ex) {
            System.out.println("Server not found: " + ex.getMessage());
        }
        catch (IOException ex) {
            System.out.println("I/O error: " + ex.getMessage());
        }
    }

    public JxeraServer(List<IJxeraPlugin> plugins, int port) {
        this.plugins = plugins.stream().collect(Collectors.toMap(IJxeraPlugin::name, Function.identity()));
        this.currentPort = port;
        new Thread(this).start();
    }

    private void serverTcp() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JxeraServer.this.isExit.get()) {
                    ArrayList<ServerTask> removedThread = new ArrayList<ServerTask>();
                    try {
                        for (ServerTask tThread : JxeraServer.this.threadList) {
                            if (!tThread.socket.isClosed() && System.currentTimeMillis() - tThread.lastTimeConnection.get() <= 5000L) continue;
                            tThread.closeConnection();
                            System.out.println("connection remove from threadList");
                            removedThread.add(tThread);
                        }
                        for (ServerTask tThread : removedThread) {
                            JxeraServer.this.threadList.remove(tThread);
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("\u043e\u0448\u0438\u0431\u043a\u0430  \u043e\u0447\u0438\u0441\u0442\u043a\u0438 \u043f\u043e\u0442\u043e\u043a\u043e\u0432: " + ex.getMessage());
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                System.out.println("thread check connection complete");
            }
        }).start();
        try (ServerSocket serverSocket = new ServerSocket(this.currentPort);){
            while (!this.isExit.get()) {
                Socket socket = serverSocket.accept();
                ServerTask thread = new ServerTask(this, socket);
                thread.start();
                this.threadList.add(thread);
            }
        }
        catch (IOException ex) {
            System.out.println("Server exception3: " + ex.getMessage());
        }
        System.out.println("thread accept ServerSocket complete");
    }

    @Override
    public void run() {
        this.serverTcp();
    }

    public void close() {
        JxeraServer.sendCloseCommand(this.currentPort);
    }

    public int getCurrentPort() {
        return this.currentPort;
    }

    public static interface IScreenGet {
        public int getMonitorCount();

        public byte[] getScreenImage(int var1);

        public void onSendClick(float var1, float var2, int var3, int var4);

        public void onSendText(String var1, int var2);
    }
}

