/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import ru.den4k.jxera2.plugin.IJxeraPlugin;
import ru.den4k.jxera2.plugin.PluginHelper;
import ru.den4k.jxera2.server.JxeraServer;
import ru.den4k.jxera2.utils.ByteUtils;
import ru.den4k.jxera2.utils.EncodeHelper;
import ru.den4k.jxera2.utils.OsUtils;

public class ServerTask
extends Thread
implements IJxeraPlugin.IJxeraServerTask {
    public static final int SERVER_VERSION = 8;
    public static final String STOP_WORD = "stop";
    public static final int ERROR_CONNECTION_NO_ERROR = 0;
    public static final int ERROR_CONNECTION_WRONG_REQUEST = -1;
    public static final int ERROR_CONNECTION_VERSION_INCOMPATIBILITY = -2;
    public static final int INDEX_AUTH = 0;
    public static final int INDEX_SERVER_VERSION = 1;
    public static final int INDEX_PLUGIN = 2;
    public static final int INDEX_UI_PARAMS = 3;
    public final Socket socket;
    private final JxeraServer server;
    private DataInputStream input;
    private DataOutputStream output;
    public AtomicLong lastTimeConnection;

    public ServerTask(JxeraServer server, Socket socket) {
        this.server = server;
        this.socket = socket;
        this.lastTimeConnection = new AtomicLong(System.currentTimeMillis());
    }

    public synchronized void closeConnection() {
        try {
            if (!this.socket.isClosed()) {
                System.out.println("closeConnection socket close");
                this.socket.close();
            }
        }
        catch (IOException ex) {
            System.out.println("Server exception1: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            this.input = new DataInputStream(this.socket.getInputStream());
            this.output = new DataOutputStream(this.socket.getOutputStream());
            String text = this.input.readUTF();
            String[] setupData = text.split(";");
            String authStr = setupData[0];
            if (!EncodeHelper.getInstance().decryptAndValidateAuthData(authStr)) {
                System.out.println("connection is closed by wrong auth");
                this.closeConnection();
                return;
            }
            int connectionError = -1;
            try {
                int clientVersion = Integer.parseInt(setupData[1]);
                connectionError = clientVersion == 8 ? 0 : -2;
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                this.closeConnection();
            }
            String PREFIX_PC_INFO = "pc-info:";
            String PREFIX_PLUGIN = "plugin:";
            String PREFIX_UI = "ui:";
            String PREFIX_ERROR = "error:";
            StringBuilder builder = new StringBuilder();
            builder.append("error:").append(connectionError).append("\n");
            builder.append("pc-info:").append(OsUtils.getCpuInfo()).append("\n");
            builder.append(PluginHelper.pluginsToConnectionData("plugin:", new ArrayList<IJxeraPlugin>(this.server.plugins.values()))).append("\n");
            if (connectionError != 0) {
                ByteUtils.writeTextUTF(this.output, builder.toString());
                System.out.println("connection is closed by wrong request, error:" + connectionError);
                this.closeConnection();
                return;
            }
            String pluginName = setupData[2];
            IJxeraPlugin plugin = this.server.plugins.get(pluginName);
            if (plugin == null) {
                ByteUtils.writeTextUTF(this.output, builder.toString());
                System.out.println("connection is closed because plugin is empty or not found");
                this.closeConnection();
                return;
            }
            String ui = URLEncoder.encode(plugin.ui(new Object[0]), StandardCharsets.UTF_8.toString());
            builder.append("ui:").append(ui).append("\n");
            ByteUtils.writeTextUTF(this.output, builder.toString());
            while (!this.socket.isClosed()) {
                text = this.input.readUTF();
                if (STOP_WORD.equals(text)) {
                    System.out.println("connection is closed by exit and text = " + text);
                    this.closeConnection();
                    return;
                }
                this.lastTimeConnection.set(System.currentTimeMillis());
                plugin.onData(this, text);
            }
        }
        catch (Exception ex) {
            System.out.println("Server exception2: " + ex.getMessage());
        }
        this.closeConnection();
    }

    @Override
    public InputStream getInputStream() {
        return this.input;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public void writeInt(int i) {
        try {
            ByteUtils.writeInt(this.output, i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeData(byte[] data) {
        try {
            ByteUtils.writeData(this.output, data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeString(String str) {
        try {
            this.output.writeUTF(str);
            this.output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void uploadFile(String path) {
        try {
            ByteUtils.loadFile(this.output, path, (size, available) -> this.lastTimeConnection.set(System.currentTimeMillis()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void downloadFile(String path) {
        try {
            ByteUtils.saveFile(this.input, path, (size, available) -> this.lastTimeConnection.set(System.currentTimeMillis()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

