/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.ui;

import com.google.zxing.WriterException;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.imgscalr.Scalr;
import ru.den4k.jxera2.plugin.IJxeraPlugin;
import ru.den4k.jxera2.screen.ScreenPlugin;
import ru.den4k.jxera2.server.JxeraServer;
import ru.den4k.jxera2.ui.CloseEvent;
import ru.den4k.jxera2.ui.SettingsFrame;
import ru.den4k.jxera2.utils.BuildHelper;
import ru.den4k.jxera2.utils.EncodeHelper;
import ru.den4k.jxera2.utils.LocalIpHelper;
import ru.den4k.jxera2.utils.OsUtils;
import ru.den4k.jxera2.utils.QrHelper;

public class UiHelper
implements ActionListener {
    public static final String VERSION = "2.3.8";
    public static final String APP_NAME = "jx-era v2.3.8";
    private static final String QR_TITLE = "jx-era v2.3.8 QR-CODE";
    private static final String SHOW = "\u041e\u0442\u043a\u0440\u044b\u0442\u044c";
    private static final String CODE = "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u043e\u0434";
    public static final String SETTINGS = "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438";
    private static final String EXIT = "\u0412\u044b\u0445\u043e\u0434";
    private static final String TEST = "\u0422\u0435\u0441\u0442 \u0432\u0432\u043e\u0434\u0430";
    private static final String BUILD = "\u0421\u043e\u0431\u0440\u0430\u0442\u044c";
    private static final int DEF_WIDTH = 380;
    private static final int DEF_HEIGHT = 380;
    public static final String iconPath = OsUtils.isWindows() ? "icon.bmp" : "icon_linux.bmp";
    private final JxeraServer screenServer;
    private Frame mainFrame;
    private Frame codeFrame = null;
    private boolean isDevMode;
    private final List<IJxeraPlugin> plugins;

    public UiHelper(int port, List<IJxeraPlugin> plugins, boolean isDevMode) throws Exception {
        this.plugins = plugins;
        this.screenServer = new JxeraServer(plugins, port);
        this.isDevMode = isDevMode;
        this.initUi();
    }

    private void initUi() throws IOException {
        this.mainFrame = this.createDefFrame(APP_NAME);
        if (!SystemTray.isSupported()) {
            this.mainFrame.setVisible(true);
            return;
        }
        this.mainFrame.setVisible(false);
        ImageIcon codeImageIcon = new ImageIcon();
        BufferedImage img = Scalr.resize(ImageIO.read(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("icon2_512.png"))), 380, 380, new BufferedImageOp[0]);
        codeImageIcon.setImage(img);
        JLabel label = new JLabel(codeImageIcon);
        label.setSize(380, 380);
        this.mainFrame.add(label);
        SystemTray tray = SystemTray.getSystemTray();
        PopupMenu popup = new PopupMenu();
        popup.add(this.createMenuItem(SHOW));
        popup.add(this.createMenuItem(CODE));
        if (this.isDevMode) {
            popup.add(this.createMenuItem(BUILD));
            popup.add(this.createMenuItem(TEST));
            popup.add(this.createMenuItem(SETTINGS));
        }
        popup.add(this.createMenuItem(EXIT));
        BufferedImage icon = ImageIO.read(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(iconPath)));
        TrayIcon trayIcon = new TrayIcon(icon, APP_NAME, popup);
        trayIcon.addActionListener(this);
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e) {
            System.err.println(e.getMessage());
        }
    }

    private void showCodeFrame(String qrStr) throws IOException, WriterException {
        ImageIcon codeImageIcon = new ImageIcon();
        if (this.codeFrame == null) {
            this.codeFrame = this.createDefFrame(QR_TITLE);
            JLabel label = new JLabel(codeImageIcon);
            label.setSize(380, 380);
            this.codeFrame.add(label);
        }
        BufferedImage img = Scalr.resize(QrHelper.createQRImage(qrStr), Scalr.Method.SPEED, Scalr.Mode.AUTOMATIC, 380, 380, new BufferedImageOp[0]);
        codeImageIcon.setImage(img);
        this.codeFrame.setVisible(true);
    }

    private MenuItem createMenuItem(String name) {
        MenuItem item = new MenuItem(name);
        item.addActionListener(this);
        return item;
    }

    private Frame createDefFrame(String title) {
        BufferedImage icon;
        Frame frame = new Frame(title);
        frame.setResizable(false);
        try {
            icon = ImageIO.read(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(iconPath)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        frame.setIconImage(icon);
        frame.setSize(380, 380);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(dim.width / 2 - frame.getSize().width / 2, dim.height / 2 - frame.getSize().height / 2);
        frame.addWindowListener(new CloseEvent(frame));
        return frame;
    }

    public void closeApp() {
        this.screenServer.close();
        for (IJxeraPlugin plugin : this.plugins) {
            plugin.onStop();
        }
        System.exit(0);
    }

    private String createConnectString() {
        String PREFIX_IP = "ip:";
        String ipData = LocalIpHelper.getLocalIpList("ip:");
        if (ipData.isEmpty()) {
            throw new RuntimeException("local ip not found");
        }
        StringBuilder builder = new StringBuilder();
        String PREFIX_PORT = "port:";
        builder.append("port:").append(this.screenServer.getCurrentPort()).append("\n");
        builder.append(ipData).append("\n");
        String PREFIX_AUTH = "auth:";
        String encryptData = EncodeHelper.getInstance().encryptAuthData();
        builder.append("auth:").append(encryptData);
        if (!encryptData.endsWith("\n")) {
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (com.equals(SHOW)) {
            this.mainFrame.setVisible(true);
        }
        if (com.equals(CODE)) {
            try {
                String connectStr = this.createConnectString();
                this.showCodeFrame(connectStr);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (WriterException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (com.equals(EXIT)) {
            this.closeApp();
        }
        if (com.equals(BUILD)) {
            BuildHelper.build();
        }
        if (com.equals(SETTINGS)) {
            SettingsFrame.getInstance().setVisible(true);
        }
        if (com.equals(TEST)) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            ScreenPlugin plugin = this.plugins.stream().filter(f -> f.name().equals("Monitor")).findFirst().orElse(null);
            plugin.onSendText("\u0439\u0446\u0443\u043a\u0435\u043d\u0433\u0448\u0449\u0437\u0445\u044a\u0444\u044b\u0432\u0430\u043f\u0440\u043e\u043b\u0434\u0436\u044d\\\u044f\u0447\u0441\u043c\u0438\u0442\u044c\u0431\u044e.");
        }
    }
}

