/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.utils;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class ByteUtils {
    public static void writeNull(DataOutputStream output) throws IOException {
        output.writeInt(0);
        output.flush();
    }

    public static void writeInt(DataOutputStream output, int v) throws IOException {
        output.writeInt(v);
        output.flush();
    }

    public static void writeData(DataOutputStream output, byte[] data) throws IOException {
        output.writeInt(data.length);
        output.write(data);
        output.flush();
    }

    public static void writeTextUTF(DataOutputStream output, String text) throws IOException {
        int bytesRead;
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        byte[] buffer = new byte[8192];
        output.writeInt(bytes.length);
        for (int count = 0; count < bytes.length && (bytesRead = bais.read(buffer)) != -1; count += bytesRead) {
            output.write(buffer, 0, bytesRead);
        }
        bais.close();
    }

    public static void loadFile(DataOutputStream output, String path, IFileUploadListener listener) throws IOException {
        int numberOfBytesRead;
        DataInputStream dis = new DataInputStream(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));
        int available = dis.available();
        int len = 0;
        output.writeInt(available);
        output.flush();
        byte[] buffer = new byte[4096];
        while ((numberOfBytesRead = dis.read(buffer)) >= 0) {
            output.writeInt(numberOfBytesRead);
            output.write(buffer, 0, numberOfBytesRead);
            output.flush();
            listener.onPartUpload(len += numberOfBytesRead, available);
            if (len != available) continue;
        }
        output.flush();
    }

    public static void saveFile(DataInputStream input, String path, IFileUploadListener listener) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        OutputStream outStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        int fullSize = input.readInt();
        int size = input.readInt();
        int len = 0;
        while (size > 0 && len < fullSize) {
            byte[] buf = new byte[size];
            input.readFully(buf);
            outStream.write(buf, 0, buf.length);
            if ((len += buf.length) == fullSize) break;
            listener.onPartUpload(0L, len);
            size = input.readInt();
        }
        outStream.flush();
        outStream.close();
    }

    public static interface IFileUploadListener {
        public void onPartUpload(long var1, long var3);
    }
}

