/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class LocalIpHelper {
    public static String getLocalIpList(String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    String ip = addr.getHostAddress();
                    if (ip == null || ip.split("\\.").length != 4) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(prefix);
                    stringBuilder.append(ip);
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return stringBuilder.toString();
    }
}

