/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.utils;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import ru.den4k.jxera2.utils.EncodeHelper;

public class SettingsHelper {
    private static final String SETTINGS_FILE_NAME = "settings.ini";

    public static int init() throws Exception {
        List<String> lines;
        File settings = new File(SETTINGS_FILE_NAME);
        EncodeHelper encodeHelper = EncodeHelper.getInstance();
        boolean needRewriteFile = true;
        int port = 4445;
        if (settings.isFile() && settings.exists() && (lines = Files.readAllLines(settings.toPath(), Charset.defaultCharset())).size() >= 2) {
            try {
                port = Integer.parseInt(lines.get(0));
                boolean setAuthDataComplete = encodeHelper.setStringFromFile(lines.get(1));
                needRewriteFile = !setAuthDataComplete;
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        if (needRewriteFile) {
            encodeHelper.resetPassword();
            settings.delete();
            String str = port + "\n" + encodeHelper.getStringForFile();
            Files.write(settings.toPath(), str.getBytes(), new OpenOption[0]);
        }
        return port;
    }
}

