/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.files;

import com.google.gson.Gson;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.den4k.jxera2.files.DirData;
import ru.den4k.jxera2.files.FileData;
import ru.den4k.jxera2.plugin.IJxeraPlugin;

public class FilesPlugin
implements IJxeraPlugin {
    private static final String PLUGIN_NAME = "Files";
    private static final String COM_GO_ROOT_DIR = "gr";
    private static final String COM_GO_PARENT_DIR = "gp";
    private static final String COM_GO_DIR = "gd";
    private static final String COM_ACTION_DIR = "ad";
    private static final String COM_ACTION_FILE = "af";
    private static final String COM_UPLOAD_FILE = "df";
    private static final String COM_DOWNLOAD_FILE = "uf";
    private String currentPath = System.getProperty("user.dir");
    static final String DOWNLOADS_DIR = System.getProperty("user.dir") + File.separator + "downloads";
    private final Gson gson = new Gson();
    private final List<String> disks = new ArrayList<String>();
    private long lastQueryFs = 0L;

    public FilesPlugin() {
        File downDir = new File(DOWNLOADS_DIR);
        if (!downDir.exists()) {
            downDir.mkdir();
        }
        this.updateDisks();
    }

    private void updateDisks() {
        File[] roots;
        ArrayList<String> disks = new ArrayList<String>();
        for (File root : roots = File.listRoots()) {
            disks.add(root.getAbsolutePath());
        }
        this.disks.clear();
        this.disks.addAll(disks);
    }

    private String getFileData() {
        try {
            File dir = new File(this.currentPath);
            List<FileData> data = Arrays.stream(Objects.requireNonNull(dir.listFiles())).map(FileData::new).collect(Collectors.toList());
            return this.gson.toJson((Object)new DirData(this.currentPath, data, this.disks));
        }
        catch (Exception ex) {
            System.out.println("!!! " + ex.getMessage());
            return "";
        }
    }

    @Override
    public String name() {
        return PLUGIN_NAME;
    }

    @Override
    public String description() {
        return "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430\u043c\u0438";
    }

    @Override
    public String ui(Object ... params) {
        return "";
    }

    @Override
    public void onData(IJxeraPlugin.IJxeraServerTask task, String input) {
        String[] parts = input.split(";");
        if (parts.length < 2) {
            if (System.currentTimeMillis() - this.lastQueryFs < 5000L) {
                task.writeString("");
            } else {
                task.writeString(this.getFileData());
                this.lastQueryFs = System.currentTimeMillis();
            }
            return;
        }
        String cmd = parts[1];
        if (COM_GO_PARENT_DIR.equals(cmd)) {
            Path parent = Paths.get(this.currentPath, new String[0]).getParent();
            if (parent == null) {
                task.writeString("");
            } else {
                this.currentPath = parent.toString();
                task.writeString(this.getFileData());
                this.lastQueryFs = System.currentTimeMillis();
            }
            System.out.println("current path = " + this.currentPath);
            return;
        }
        if (COM_GO_ROOT_DIR.equals(cmd)) {
            this.currentPath = Paths.get(this.currentPath, new String[0]).getRoot().toString();
            System.out.println("current path = " + this.currentPath);
            task.writeString(this.getFileData());
            this.lastQueryFs = System.currentTimeMillis();
            return;
        }
        if (COM_GO_DIR.equals(cmd) && parts.length >= 3) {
            this.currentPath = parts[2];
            System.out.println("current path = " + this.currentPath);
            task.writeString(this.getFileData());
            this.lastQueryFs = System.currentTimeMillis();
            return;
        }
        if (COM_ACTION_DIR.equals(cmd) && parts.length >= 3) {
            if (!this.currentPath.endsWith(File.separator)) {
                this.currentPath = this.currentPath + File.separator;
            }
            this.currentPath = this.currentPath + parts[2];
            System.out.println("current path = " + this.currentPath);
            task.writeString(this.getFileData());
            this.lastQueryFs = System.currentTimeMillis();
            return;
        }
        if (COM_UPLOAD_FILE.equals(cmd) && parts.length >= 3) {
            Object path = this.currentPath;
            if (!((String)path).endsWith(File.separator)) {
                path = (String)path + File.separator;
            }
            path = (String)path + parts[2];
            System.out.println("upload file: " + (String)path);
            task.uploadFile((String)path);
            return;
        }
        if (COM_DOWNLOAD_FILE.equals(cmd) && parts.length >= 3) {
            String path = DOWNLOADS_DIR + File.separator + parts[2];
            System.out.println("download file: " + path);
            task.downloadFile(path);
            return;
        }
        task.writeString("");
    }

    @Override
    public void onStop() {
    }
}

