/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.plugin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.den4k.jxera2.files.FilesPlugin;
import ru.den4k.jxera2.plugin.CustomClassLoader;
import ru.den4k.jxera2.plugin.IJxeraPlugin;
import ru.den4k.jxera2.screen.ScreenPlugin;

public class PluginHelper {
    private static Set<String> listFilesUsingJavaIO(String dir) {
        return Stream.of(new File(dir).listFiles()).filter(File::isDirectory).map(f -> f.getAbsolutePath()).collect(Collectors.toSet());
    }

    private static IJxeraPlugin pathToPlugin(String path) {
        Constructor<?> ctor;
        Class<?> clazz;
        CustomClassLoader urlcl;
        try {
            urlcl = new CustomClassLoader(path);
        }
        catch (MalformedURLException e) {
            System.out.println(e.getMessage());
            return null;
        }
        try {
            clazz = ((ClassLoader)urlcl).loadClass("JxeraPlugin");
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            return null;
        }
        try {
            ctor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e.getMessage());
            return null;
        }
        try {
            return (IJxeraPlugin)ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static List<IJxeraPlugin> initPlugins() {
        String pluginsDirStr = "plugins";
        File pluginsDir = new File(pluginsDirStr);
        if (!pluginsDir.exists() || pluginsDir.isFile()) {
            pluginsDir.mkdir();
        }
        Set<String> pluginDirs = PluginHelper.listFilesUsingJavaIO(pluginsDirStr);
        HashSet<String> pluginIndexes = new HashSet<String>();
        for (String dir : pluginDirs) {
            File file = new File(dir + File.separator + "index.jar");
            boolean exist = file.exists();
            boolean isFile = file.isFile();
            if (!exist || !isFile) continue;
            pluginIndexes.add(file.getAbsolutePath());
        }
        List<IJxeraPlugin> res = pluginIndexes.stream().map(PluginHelper::pathToPlugin).filter(Objects::nonNull).collect(Collectors.toList());
        res.add(0, new ScreenPlugin());
        res.add(0, new FilesPlugin());
        return res;
    }

    public static String pluginsToConnectionData(String prefix, List<IJxeraPlugin> plugins) {
        StringBuilder builder = new StringBuilder();
        for (IJxeraPlugin p : plugins) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(prefix).append(p.name()).append(";").append(p.description());
        }
        return builder.toString();
    }
}

