/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.screen;

import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class KeySender {
    public static final Charset CS_1251 = Charset.forName("windows-1251");
    public static final Charset CS_UTF8 = StandardCharsets.UTF_8;

    private static Character getShiftedKey(char c) {
        if (c == '~') {
            return Character.valueOf('`');
        }
        if (c == ')') {
            return Character.valueOf('0');
        }
        if (c == '!') {
            return Character.valueOf('1');
        }
        if (c == '@') {
            return Character.valueOf('2');
        }
        if (c == '#') {
            return Character.valueOf('3');
        }
        if (c == '$') {
            return Character.valueOf('4');
        }
        if (c == '%') {
            return Character.valueOf('5');
        }
        if (c == '^') {
            return Character.valueOf('6');
        }
        if (c == '&') {
            return Character.valueOf('7');
        }
        if (c == '*') {
            return Character.valueOf('8');
        }
        if (c == '(') {
            return Character.valueOf('9');
        }
        if (c == '{') {
            return Character.valueOf('[');
        }
        if (c == '}') {
            return Character.valueOf(']');
        }
        if (c == '_') {
            return Character.valueOf('-');
        }
        if (c == '+') {
            return Character.valueOf('=');
        }
        if (c == '<') {
            return Character.valueOf(',');
        }
        if (c == '>') {
            return Character.valueOf('.');
        }
        if (c == '?') {
            return Character.valueOf('/');
        }
        if (c == ':') {
            return Character.valueOf(';');
        }
        if (c == '\"') {
            return Character.valueOf('\'');
        }
        if (c == '|') {
            return Character.valueOf('\\');
        }
        return null;
    }

    private static Character rusToLatin(char c, boolean is1251) {
        System.out.println("char " + c + " = " + c);
        if (c == '\u0439') {
            return Character.valueOf('q');
        }
        if (c == '\u0446') {
            return Character.valueOf('w');
        }
        if (c == '\u0443') {
            return Character.valueOf('e');
        }
        if (c == '\u043a') {
            return Character.valueOf('r');
        }
        if (c == '\u0435') {
            return Character.valueOf('t');
        }
        if (c == '\u043d') {
            return Character.valueOf('y');
        }
        if (c == '\u0433') {
            return Character.valueOf('u');
        }
        if (c == '\u0448') {
            return Character.valueOf('i');
        }
        if (c == '\u0449') {
            return Character.valueOf('o');
        }
        if (c == '\u0437') {
            return Character.valueOf('p');
        }
        if (c == '\u0445' || c == '\u0445') {
            return Character.valueOf('[');
        }
        if (c == '\u044a' || c == '\u044a') {
            return Character.valueOf(']');
        }
        if (c == '\u0444') {
            return Character.valueOf('a');
        }
        if (c == '\u044b') {
            return Character.valueOf('s');
        }
        if (c == '\u0432') {
            return Character.valueOf('d');
        }
        if (c == '\u0430') {
            return Character.valueOf('f');
        }
        if (c == '\u043f') {
            return Character.valueOf('g');
        }
        if (c == '\u0440') {
            return Character.valueOf('h');
        }
        if (c == '\u043e') {
            return Character.valueOf('j');
        }
        if (c == '\u043b') {
            return Character.valueOf('k');
        }
        if (c == '\u0434') {
            return Character.valueOf('l');
        }
        if (c == '\u0436') {
            return Character.valueOf(';');
        }
        if (c == '\u044d') {
            return Character.valueOf('\'');
        }
        if (c == '\u044f') {
            return Character.valueOf('z');
        }
        if (c == '\u0447') {
            return Character.valueOf('x');
        }
        if (c == '\u0441') {
            return Character.valueOf('c');
        }
        if (c == '\u043c') {
            return Character.valueOf('v');
        }
        if (c == '\u0438') {
            return Character.valueOf('b');
        }
        if (c == '\u0442') {
            return Character.valueOf('n');
        }
        if (c == '\u044c') {
            return Character.valueOf('m');
        }
        if (c == '\u0431') {
            return Character.valueOf(',');
        }
        if (c == '\u044e') {
            return Character.valueOf('.');
        }
        if (c == '\u0451') {
            return Character.valueOf('`');
        }
        if (c == '\u0419') {
            return Character.valueOf('Q');
        }
        if (c == '\u0426') {
            return Character.valueOf('W');
        }
        if (c == '\u0423') {
            return Character.valueOf('E');
        }
        if (c == '\u041a') {
            return Character.valueOf('R');
        }
        if (c == '\u0415') {
            return Character.valueOf('T');
        }
        if (c == '\u041d') {
            return Character.valueOf('Y');
        }
        if (c == '\u0413') {
            return Character.valueOf('U');
        }
        if (c == '\u0428') {
            return Character.valueOf('I');
        }
        if (c == '\u0429') {
            return Character.valueOf('O');
        }
        if (c == '\u0417') {
            return Character.valueOf('P');
        }
        if (c == '\u0425' || c == '\u0425') {
            return Character.valueOf('{');
        }
        if (c == '\u042a' || c == '\u042a') {
            return Character.valueOf('}');
        }
        if (c == '\u0424') {
            return Character.valueOf('A');
        }
        if (c == '\u042b') {
            return Character.valueOf('S');
        }
        if (c == '\u0412') {
            return Character.valueOf('D');
        }
        if (c == '\u0410') {
            return Character.valueOf('F');
        }
        if (c == '\u041f') {
            return Character.valueOf('G');
        }
        if (c == '\u0420') {
            return Character.valueOf('H');
        }
        if (c == '\u041e') {
            return Character.valueOf('J');
        }
        if (c == '\u041b') {
            return Character.valueOf('K');
        }
        if (c == '\u0414') {
            return Character.valueOf('L');
        }
        if (c == '\u0416') {
            return Character.valueOf(':');
        }
        if (c == '\u042d') {
            return Character.valueOf('\"');
        }
        if (c == '\u042f') {
            return Character.valueOf('Z');
        }
        if (c == '\u0427') {
            return Character.valueOf('X');
        }
        if (c == '\u0421') {
            return Character.valueOf('C');
        }
        if (c == '\u041c') {
            return Character.valueOf('V');
        }
        if (c == '\u0418') {
            return Character.valueOf('B');
        }
        if (c == '\u0422') {
            return Character.valueOf('N');
        }
        if (c == '\u042c') {
            return Character.valueOf('M');
        }
        if (c == '\u0411') {
            return Character.valueOf('<');
        }
        if (c == '\u042e') {
            return Character.valueOf('>');
        }
        if (c == '\u0401') {
            return Character.valueOf('~');
        }
        return null;
    }

    private static int getNotCheckedKode(char c) {
        if (c == '[') {
            return 91;
        }
        if (c == ']') {
            return 93;
        }
        if (c == '-') {
            return 45;
        }
        if (c == '=') {
            return 61;
        }
        if (c == ',') {
            return 44;
        }
        if (c == '.') {
            return 46;
        }
        if (c == '/') {
            return 47;
        }
        if (c == ';') {
            return 59;
        }
        if (c == '\'') {
            return 222;
        }
        if (c == '\\') {
            return 92;
        }
        return -1;
    }

    public static void pasteText(Robot robot, String text) {
        StringSelection selection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, null);
        String os = System.getProperty("os.name").toLowerCase();
        int modifierKey = os.contains("mac") ? 157 : 17;
        robot.keyPress(modifierKey);
        robot.keyPress(86);
        robot.keyRelease(86);
        robot.keyRelease(modifierKey);
        robot.delay(100);
    }

    public static void sendText(Robot robot, String text) {
        boolean is1251 = Charset.defaultCharset().equals(CS_1251);
        for (char ch : text.toCharArray()) {
            Character shiftChar;
            boolean needShift;
            char c = ch;
            Character tChr = KeySender.rusToLatin(c, is1251);
            if (tChr != null) {
                c = tChr.charValue();
            }
            if (!(needShift = Character.isUpperCase(c)) && (shiftChar = KeySender.getShiftedKey(c)) != null) {
                c = shiftChar.charValue();
                needShift = true;
            }
            System.out.println("!!! char=" + c + " needShift=" + needShift + "   code=" + c + "   is1251=" + is1251);
            int keyCode = KeySender.getNotCheckedKode(c);
            if (keyCode < 0) {
                try {
                    keyCode = KeyEvent.getExtendedKeyCodeForChar(c);
                    System.out.println("key code getExtendedKeyCodeForChar = " + keyCode);
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                    continue;
                }
                if (65535 == keyCode) {
                    System.out.println("Key code not found for character '" + c + "'");
                    continue;
                }
            }
            if (needShift) {
                robot.keyPress(16);
            }
            robot.keyPress(keyCode);
            robot.delay(15);
            robot.keyRelease(keyCode);
            if (needShift) {
                robot.keyRelease(16);
            }
            System.out.println("key code release = " + keyCode);
            robot.delay(15);
        }
    }
}

