/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.ui;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import ru.den4k.jxera2.ui.CloseEvent;
import ru.den4k.jxera2.ui.UiHelper;
import ru.den4k.jxera2.utils.OsUtils;

public class SettingsFrame
extends Frame {
    private static SettingsFrame instance = null;

    public static synchronized SettingsFrame getInstance() {
        if (instance == null) {
            instance = new SettingsFrame();
        }
        return instance;
    }

    public SettingsFrame() {
        BufferedImage icon;
        this.setResizable(false);
        this.setTitle("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438");
        try {
            icon = ImageIO.read(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(UiHelper.iconPath)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setIconImage(icon);
        this.setSize(640, 480);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        this.addWindowListener(new CloseEvent(this));
        Panel panel = new Panel();
        panel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        panel.setLayout(new FlowLayout(0));
        panel.add(this.createCheckDockerButton());
        panel.add(this.createGoDockerButton());
        this.add(panel);
    }

    private void showMessage(String text) {
        JOptionPane.showMessageDialog(this, text, "jx-era v2.3.8", 1);
    }

    private JButton createCheckDockerButton() {
        JButton button = new JButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c Docker");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsFrame.this.showMessage(OsUtils.isDockerInstalled() ? "Docker Installed" : "Docker Not installed");
            }
        });
        return button;
    }

    private JButton createGoDockerButton() {
        JButton button = new JButton("\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u043d\u0430 \u0441\u0430\u0439\u0442 Docker");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsUtils.openWebpage("https://www.docker.com/");
            }
        });
        return button;
    }
}

