/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import ru.den4k.jxera2.utils.OsUtils;

public class BuildHelper {
    public static void build() {
        System.out.println("build");
        System.out.println("remove target:");
        OsUtils.deleteDir(new File("target"));
        OsUtils.exec("mvn compile assembly:single");
        File[] bFiles = BuildHelper.findBuildJar("target");
        if (bFiles.length == 0) {
            System.out.println("build file *.jar not found");
            return;
        }
        File buildDir = new File("jxera_" + "2.3.8".replace(".", "_"));
        if (buildDir.exists()) {
            OsUtils.deleteDir(buildDir);
        }
        buildDir.mkdir();
        try {
            OsUtils.copyFile(bFiles[0], buildDir.getPath() + File.separator + "jxera.jar");
            OsUtils.copyFile(new File("jxera.bat"), buildDir.getPath() + File.separator + "jxera.bat");
            OsUtils.copyDirectory("plugins", buildDir.getPath() + File.separator + "plugins");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        OsUtils.deleteDir(new File("android" + File.separator + "app" + File.separator + "build"));
        File[] aFiles = BuildHelper.findApk("../android");
        System.out.println("remove old apk files");
        for (File f : aFiles) {
            boolean delRes = f.delete();
            System.out.println("remove " + f.getName() + "     result: " + delRes);
        }
        String androidDir = ".." + File.separator + "android";
        OsUtils.exec("compile.bat", androidDir);
        aFiles = BuildHelper.findBuildApk(androidDir);
        if (aFiles.length == 0) {
            System.out.println("apk file *.apk not found");
            return;
        }
        try {
            OsUtils.copyFile(aFiles[0], buildDir.getPath() + File.separator + aFiles[0].getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("complete!!!");
    }

    private static File[] findBuildJar(String pathDir) {
        File f = new File(pathDir);
        File[] matchingFiles = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jxera") && name.endsWith("with-dependencies.jar");
            }
        });
        return matchingFiles;
    }

    private static File[] findApk(String pathDir) {
        File f = new File(pathDir);
        File[] matchingFiles = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".apk");
            }
        });
        return matchingFiles;
    }

    private static File[] findBuildApk(String pathDir) {
        File f = new File(pathDir);
        File[] matchingFiles = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jx-era") && name.endsWith(".apk");
            }
        });
        return matchingFiles;
    }
}

