/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.utils;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;

public class OsUtils {
    private static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return OsUtils.getOsName().startsWith("Windows");
    }

    public static String getCpuInfo() {
        String numCore = System.getenv("NUMBER_OF_PROCESSORS");
        String processorId = System.getenv("PROCESSOR_IDENTIFIER");
        String architecture = System.getenv("PROCESSOR_ARCHITECTURE");
        StringBuilder builder = new StringBuilder();
        builder.append(numCore != null ? numCore : "???");
        builder.append(" core ");
        builder.append(processorId != null ? processorId : "???");
        builder.append(" ");
        builder.append(architecture != null ? architecture : "???");
        return builder.toString();
    }

    public static String exec(String command) {
        return OsUtils.exec(command, null);
    }

    public static String exec(String command, String workingDir) {
        String[] commands = new String[]{OsUtils.isWindows() ? "cmd.exe" : "sh", OsUtils.isWindows() ? "/c" : "-c", command};
        return OsUtils.exec(commands, workingDir);
    }

    private static String exec(String[] commands, String workingDir) {
        String command = String.join((CharSequence)" ", commands);
        System.out.printf("Executing '%s'%n", command);
        try {
            Process process;
            ProcessBuilder builder = new ProcessBuilder(commands);
            if (workingDir != null) {
                builder.directory(new File(workingDir));
            }
            if (!(process = builder.start()).waitFor(120L, TimeUnit.SECONDS)) {
                process.destroy();
                return "Timeout exceeded";
            }
            String successLog = OsUtils.getLog(process.getInputStream());
            return !successLog.isEmpty() ? successLog : "[ERROR]\n" + OsUtils.getLog(process.getErrorStream());
        }
        catch (IOException e) {
            return "I/O error: " + e.getMessage();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return String.format("Execution '%s' was interrupted", command);
        }
    }

    private static String getLog(InputStream stream) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        return sb.toString();
    }

    public static void copyDirectory(String sourceDirectory, String destinationDirectory) throws IOException {
        OsUtils.copyDirectory(new File(sourceDirectory), new File(destinationDirectory));
    }

    private static void copyDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdir();
        }
        for (String f : sourceDirectory.list()) {
            OsUtils.copyDirectoryCompatibityMode(new File(sourceDirectory, f), new File(destinationDirectory, f));
        }
    }

    private static void copyDirectoryCompatibityMode(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            OsUtils.copyDirectory(source, destination);
        } else {
            OsUtils.copyFile(source, destination);
        }
    }

    public static void copyFile(File copied, String to) throws IOException {
        OsUtils.copyFile(copied, new File(to));
    }

    public static void copyFile(File copied, File to) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(copied.toPath(), new OpenOption[0]));
             BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(to.toPath(), new OpenOption[0]));){
            int lengthRead;
            byte[] buffer = new byte[1024];
            while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, lengthRead);
                ((OutputStream)out).flush();
            }
        }
    }

    public static void deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                OsUtils.deleteDir(f);
            }
        }
        file.delete();
    }

    public static boolean isDockerInstalled() {
        String command = OsUtils.isWindows() ? "cmd.exe /c docker --version" : "/bin/sh -c \"command -v docker && docker --version\"";
        try {
            Process process = Runtime.getRuntime().exec(command);
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 Docker: " + e.getMessage());
            return false;
        }
    }

    public static void openWebpage(String url) {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(new URI(url));
            } else {
                Runtime runtime = Runtime.getRuntime();
                if (os.contains("win")) {
                    runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else if (os.contains("mac")) {
                    runtime.exec("open " + url);
                } else {
                    runtime.exec("xdg-open " + url);
                }
            }
        }
        catch (IOException | URISyntaxException ex) {
            JOptionPane.showMessageDialog(null, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0431\u0440\u0430\u0443\u0437\u0435\u0440: " + ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
        }
    }
}

