/*
 * Decompiled with CFR 0.152.
 */
package ru.den4k.jxera2.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.util.EnumMap;
import java.util.Map;

public final class QrCodePrintHelper {
    private static final String BLACK = "\u001b[40m  \u001b[0m";
    private static final String WHITE = "\u001b[47m  \u001b[0m";
    private static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";
    private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};

    private QrCodePrintHelper() {
    }

    public static void print(String content) {
        QrCodePrintHelper.generateQrcodeBitMatrix(content, new QrcodeBlock(){

            @Override
            public void invoke(int maxWidth, BitMatrix bitMatrix) {
                for (int i = 0; i < maxWidth; ++i) {
                    for (int j = 0; j < maxWidth; ++j) {
                        System.out.print(bitMatrix.get(i, j) ? QrCodePrintHelper.BLACK : QrCodePrintHelper.WHITE);
                    }
                    System.out.print('\n');
                }
            }
        });
    }

    public static String generateUnicodeQrcode(String content) {
        final StringBuilder r = new StringBuilder();
        QrCodePrintHelper.generateQrcodeBitMatrix(content, new QrcodeBlock(){

            @Override
            public void invoke(int maxWidth, BitMatrix bitMatrix) {
                for (int i = 0; i < maxWidth - 1; i += 2) {
                    for (int j = 0; j < maxWidth; ++j) {
                        int t = bitMatrix.get(i, j) ? 2 : 0;
                        int b = bitMatrix.get(i + 1, j) ? 1 : 0;
                        int s = t + b;
                        r.append(switch (s) {
                            case 0 -> ' ';
                            case 2 -> '\u2580';
                            case 1 -> '\u2584';
                            case 3 -> '\u2588';
                            default -> throw new Error("impossible map: " + Integer.toString(s, 2));
                        });
                    }
                    r.append('\n');
                }
            }
        });
        return r.toString();
    }

    private static void generateQrcodeBitMatrix(String content, QrcodeBlock block) {
        EnumMap<EncodeHintType, Object> hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hints.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
        int maxWidth = 8;
        try {
            maxWidth += QrCodePrintHelper.getVersion(content, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        int width = maxWidth;
        int height = maxWidth;
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        block.invoke(maxWidth, bitMatrix);
    }

    private static int getVersion(String content, Map<EncodeHintType, Object> hints) throws WriterException {
        CharacterSetECI eci;
        String encoding = DEFAULT_BYTE_MODE_ENCODING;
        if (hints != null && hints.containsKey(EncodeHintType.CHARACTER_SET)) {
            encoding = hints.get(EncodeHintType.CHARACTER_SET).toString();
        }
        Mode mode = QrCodePrintHelper.chooseMode(content, encoding);
        BitArray headerBits = new BitArray();
        if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(encoding) && (eci = CharacterSetECI.getCharacterSetECIByName((String)encoding)) != null) {
            QrCodePrintHelper.appendECI(eci, headerBits);
        }
        QrCodePrintHelper.appendModeInfo(mode, headerBits);
        BitArray dataBits = new BitArray();
        QrCodePrintHelper.appendBytes(content, mode, dataBits, encoding);
        int provisionalBitsNeeded = QrCodePrintHelper.calculateBitsNeeded(mode, headerBits, dataBits, Version.getVersionForNumber((int)1));
        for (int versionNum = 1; versionNum <= 40; ++versionNum) {
            Version version = Version.getVersionForNumber((int)versionNum);
            if (!QrCodePrintHelper.willFit(provisionalBitsNeeded, version, ErrorCorrectionLevel.L)) continue;
            return version.getVersionNumber() * 4 + 17;
        }
        return 177;
    }

    private static boolean willFit(int numInputBits, Version version, ErrorCorrectionLevel ecLevel) {
        int totalInputBytes;
        int numEcBytes;
        int numBytes = version.getTotalCodewords();
        int numDataBytes = numBytes - (numEcBytes = version.getECBlocksForLevel(ecLevel).getTotalECCodewords());
        return numDataBytes >= (totalInputBytes = (numInputBits + 7) / 8);
    }

    private static int calculateBitsNeeded(Mode mode, BitArray headerBits, BitArray dataBits, Version version) {
        return headerBits.getSize() + mode.getCharacterCountBits(version) + dataBits.getSize();
    }

    private static Mode chooseMode(String content, String encoding) {
        if ("Shift_JIS".equals(encoding) && QrCodePrintHelper.isOnlyDoubleByteKanji(content)) {
            return Mode.KANJI;
        }
        boolean hasNumeric = false;
        boolean hasAlphanumeric = false;
        for (int i = 0; i < content.length(); ++i) {
            char element = content.charAt(i);
            if (element >= '0' && element <= '9') {
                hasNumeric = true;
                continue;
            }
            if (QrCodePrintHelper.getAlphanumericCode(element) != -1) {
                hasAlphanumeric = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (hasAlphanumeric) {
            return Mode.ALPHANUMERIC;
        }
        return hasNumeric ? Mode.NUMERIC : Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String content) {
        byte[] bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException ignored) {
            return false;
        }
        int length = bytes.length;
        if (length % 2 != 0) {
            return false;
        }
        for (int i = 0; i < length; i += 2) {
            int byte1 = bytes[i] & 0xFF;
            if (byte1 >= 129 && byte1 <= 159 || byte1 >= 224 && byte1 <= 235) continue;
            return false;
        }
        return true;
    }

    private static int getAlphanumericCode(int code) {
        if (code < ALPHANUMERIC_TABLE.length) {
            return ALPHANUMERIC_TABLE[code];
        }
        return -1;
    }

    public static void appendBytes(String content, Mode mode, BitArray bits, String encoding) throws WriterException {
        switch (mode) {
            case NUMERIC: {
                QrCodePrintHelper.appendNumericBytes(content, bits);
                break;
            }
            case ALPHANUMERIC: {
                QrCodePrintHelper.appendAlphanumericBytes(content, bits);
                break;
            }
            case BYTE: {
                QrCodePrintHelper.append8BitBytes(content, bits, encoding);
                break;
            }
            case KANJI: {
                QrCodePrintHelper.appendKanjiBytes(content, bits);
                break;
            }
            default: {
                throw new WriterException("Invalid mode: " + String.valueOf(mode));
            }
        }
    }

    private static void appendNumericBytes(CharSequence content, BitArray bits) {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int num2;
            int num1 = content.charAt(i) - 48;
            if (i + 2 < length) {
                num2 = content.charAt(i + 1) - 48;
                int num3 = content.charAt(i + 2) - 48;
                bits.appendBits(num1 * 100 + num2 * 10 + num3, 10);
                i += 3;
                continue;
            }
            if (i + 1 < length) {
                num2 = content.charAt(i + 1) - 48;
                bits.appendBits(num1 * 10 + num2, 7);
                i += 2;
                continue;
            }
            bits.appendBits(num1, 4);
            ++i;
        }
    }

    public static void append8BitBytes(String content, BitArray bits, String encoding) throws WriterException {
        byte[] bytes;
        try {
            bytes = content.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException((Throwable)uee);
        }
        for (byte b : bytes) {
            bits.appendBits(b & 0xFF, 8);
        }
    }

    public static void appendKanjiBytes(String content, BitArray bits) throws WriterException {
        byte[] bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException((Throwable)uee);
        }
        int length = bytes.length;
        for (int i = 0; i < length; i += 2) {
            int byte1 = bytes[i] & 0xFF;
            int byte2 = bytes[i + 1] & 0xFF;
            int code = byte1 << 8 | byte2;
            int subtracted = -1;
            if (code >= 33088 && code <= 40956) {
                subtracted = code - 33088;
            } else if (code >= 57408 && code <= 60351) {
                subtracted = code - 49472;
            }
            if (subtracted == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int encoded = (subtracted >> 8) * 192 + (subtracted & 0xFF);
            bits.appendBits(encoded, 13);
        }
    }

    public static void appendAlphanumericBytes(CharSequence content, BitArray bits) throws WriterException {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int code1 = QrCodePrintHelper.getAlphanumericCode(content.charAt(i));
            if (code1 == -1) {
                throw new WriterException();
            }
            if (i + 1 < length) {
                int code2 = QrCodePrintHelper.getAlphanumericCode(content.charAt(i + 1));
                if (code2 == -1) {
                    throw new WriterException();
                }
                bits.appendBits(code1 * 45 + code2, 11);
                i += 2;
                continue;
            }
            bits.appendBits(code1, 6);
            ++i;
        }
    }

    private static void appendECI(CharacterSetECI eci, BitArray bits) {
        bits.appendBits(Mode.ECI.getBits(), 4);
        bits.appendBits(eci.getValue(), 8);
    }

    private static void appendModeInfo(Mode mode, BitArray bits) {
        bits.appendBits(mode.getBits(), 4);
    }

    private static interface QrcodeBlock {
        public void invoke(int var1, BitMatrix var2);
    }
}

